import math

from mathhelper import *
import engine

def resolveSkill(skill, source, target):
    sourceStr = engine.getName(source)
    targetStr = engine.getName(target)

    engine.log("%s used skill %s on %s" % (sourceStr, skill.name, targetStr))
    
    return skill.resolve(source, target)

def resolveMagicAttack(source, target, scalar=1):
    sourceStr = engine.getName(source)
    targetStr = engine.getName(target)
    
    dmg = int(source.mag + round((random.random() - 0.5) * source.mag))
    dmg = int(round(max(dmg - target.wil, math.ceil(source.mag / 10)) * scalar))
    dmg = min(dmg, target.health)
    if dmg < 0:
        dmg = 0
    engine.log("%s hit %s for %s magic damage" % (sourceStr, targetStr, dmg))
    
    target.inflictDamage(dmg, source)
    
    return dmg

def resolvePhysicalAttack(source, target, scalar=1):
    # hit chance
    baseToHit = 0.5
    
    sourceStr = engine.getName(source)
    targetStr = engine.getName(target)
    
    agiDif = abs(source.agi - target.agi)
    trgAgi = max(1, target.agi)
    srcAgi = max(1, source.agi)
    if source.agi > target.agi:
        toHitMod = float(agiDif) / trgAgi / 2.0
    elif source.agi < target.agi:
        toHitMod = -float(agiDif) / srcAgi / 4.0
    else:
        toHitMod = 0
        
    toHit = clamp(baseToHit + toHitMod, 0.2, 0.8)
    
    if not success(toHit):
        engine.log("%s swung at %s, but missed" % (sourceStr, targetStr))
        return None

    # damage
    dmg = int(source.str + round((random.random() - 0.5) * source.str))
    dmg = int(round(max(dmg - target.con, math.ceil(source.str / 10)) * scalar))
    
    dmg = min(dmg, target.health)
    if dmg < 0:
        dmg = 0
    
    engine.log("%s hit %s for %s damage" % (sourceStr, targetStr, dmg))
    target.inflictDamage(dmg, source)
    
    return dmg

def inflictCondition(source, target, condition):
    sourceStr = engine.getName(source)
    targetStr = engine.getName(target)

    if not condition in target.conditions:
        engine.log("%s inflicted %s condition on %s" % (sourceStr, condition, targetStr))
        target.conditions.append(condition)