import ConfigParser as configparser # import as configparser for python 3.0 compatibility

try:
    from cStringIO import StringIO
except:
    from StringIO import StringIO

import pygame

defaultCfg = \
"""[Engine]
mastervolume = 50
soundvolume = 100
musicvolume = 100
attackonbump = False
attackconfirms = True
remembertarget = True
multikeydiagonals = False

[KeyBinds]
up = 264
upalt = 273
down = 258
downalt = 274
left = 260
leftalt = 276
right = 262
rightalt = 275
upleft = 263
upleftalt = 
upright = 265
uprightalt = 
downleft = 257
downleftalt = 
downright = 259
downrightalt = 
wait = 261
waitalt = 
waitorconfirm = 32
waitorconfirmalt = 
confirm = 13
confirmalt = 271
cancel = 27
cancelalt = 
attack = 97
attackalt = 49
skills = 115
skillsalt = 50
status = 100
statusalt = 51
form = 102
formalt = 52
log = 108
logalt = 53
windowsizedown = 290
windowsizedownalt = 
windowsizeup = 291
windowsizeupalt = 
"""

class ConfigOption(object):
    def __init__(self, optType, name, value, altValue, rawValue, rawAltValue):
        self.type = optType
        self.name = name
        
        # This is unreliable for strings, as they can evaluate to a boolean value
        # Instead when expecting a string, use rawValue or rawAlt
        self.value = value
        self.alt = altValue
        
        self.rawValue = rawValue
        self.rawAlt = rawAltValue

class Config(object):
    def __init__(self, fileName):
        self.config = None
        self.fileName = fileName
        
        self.read()
        
    def read(self):
        try:
            f = open(self.fileName)
        except IOError:
            print "creating new config"
            self.createDefaultConfig()
            f = open(self.fileName)
        
        global defaultCfg
        
        self.config = configparser.RawConfigParser()
        
        self.config.readfp(StringIO(defaultCfg))
        self.config.readfp(f)
        
        f.close()
        
    def save(self):
        with file(self.fileName, 'w') as f:
            self.config.write(f)
        
    def getOption(self, section, name, hasAlt=True):
        if not self.config.has_option(section, name):
            return None
        
        rawValue = self.config.get(section, name)
        value = self.parse(rawValue)
        
        if hasAlt:
            rawAltValue = self.config.get(section, name + "Alt")
            altValue = self.parse(rawAltValue)
        else:
            rawAltValue = None
            altValue = None
            
        return ConfigOption(section, name, value, altValue, rawValue, rawAltValue)
    
    def getValue(self, section, name):
        if not self.config.has_option(section, name):
            return None
        
        rawValue = self.config.get(section, name)
        value = self.parse(rawValue)
            
        return value
    
    def set(self, section, name, value, hasAlt = False, altValue = None):
        if value == None:
            value = ""
        if altValue == None:
            altValue = ""
        
        self.config.set(section, name, value)
        
        if hasAlt:
            self.config.set(section, name + "Alt", altValue)
    
    def getOptions(self):
        options = []
        
        for section in self.config.sections():
            options += self.config.options(section)
            
        return options
    
    def parse(self, value):
        parsed = None
        
        if not isinstance(value, basestring):
            return value
        
        if value == "":
            value = None
        elif value.lower() == "true":
            parsed = True
        elif value.lower() == "false":
            parsed = False
        else:
            isStr = False
            
            numerals = ".0123456789"
            for char in value.strip():
                if not char in numerals:
                    isStr = True
                    break
            
            if isStr:
                parsed = value
            else:
                if '.' in value:
                    parsed = float(value.strip())
                else:
                    parsed = int(value.strip())
        
        return parsed
        
    def createDefaultConfig(self):
        global defaultCfg
        
        with open(self.fileName, 'w') as f:
            f.write(defaultCfg)
