import os
import pygame
from pygame import Rect

import sound

images = {}
sounds = {}
music = {}

def loadImage(fileName):
    global images
    img = pygame.image.load("image/%s" % fileName)
    name = os.path.splitext(fileName)[0]
    images[name] = img
    
def loadSound(fileName):
    global sounds
    snd = sound.Sound("sound/%s" % fileName)
    name = os.path.splitext(fileName)[0]
    sounds[name] = snd
    
def loadMusic(fileName, paired=False, threaded=False):
    global music
    split = os.path.splitext(fileName)
    name = split[0]
    ext = split[1]
    snd1 = sound.Sound("music/%sa%s" % (name, ext), threaded=True, regulateVolume=False)
    snd2 = sound.Sound("music/%sb%s" % (name, ext), threaded=True, regulateVolume=False)
    music[name] = (snd1, snd2)

def subImage(name, parent, rect):
    global images
    img = images[parent].subsurface(rect)
    images[name] = img

def init():
    loadImage("tiles.png")
    subImage("wall0", "tiles", Rect(0, 0, 16, 16))
    subImage("wall1", "tiles", Rect(16, 0, 16, 16))
    subImage("wall2", "tiles", Rect(32, 0, 16, 16))
    subImage("wall3", "tiles", Rect(48, 0, 16, 16))
    subImage("wall4", "tiles", Rect(0, 16, 16, 16))
    subImage("wall5", "tiles", Rect(16, 16, 16, 16))
    subImage("wall6", "tiles", Rect(32, 16, 16, 16))
    subImage("wall7", "tiles", Rect(48, 16, 16, 16))
    subImage("wall8", "tiles", Rect(0, 32, 16, 16))
    subImage("wall9", "tiles", Rect(16, 32, 16, 16))
    subImage("wall10", "tiles", Rect(32, 32, 16, 16))
    subImage("wall11", "tiles", Rect(48, 32, 16, 16))
    subImage("floor0", "tiles", Rect(48, 48, 16, 16))
    subImage("floor1", "tiles", Rect(0, 48, 16, 16))
    subImage("floor2", "tiles", Rect(16, 48, 16, 16))
    subImage("floor3", "tiles", Rect(32, 48, 16, 16))
    subImage("stairsup", "tiles", Rect(0, 64, 16, 16))
    subImage("stairsdown", "tiles", Rect(16, 64, 16, 16))
    
    loadImage("monsters.png")
    
    subImage("imp", "monsters", Rect(0, 0, 16, 16))
    subImage("rat", "monsters", Rect(16, 0, 16, 16))
    subImage("skeleton", "monsters", Rect(32, 0, 16, 16))
    subImage("bat", "monsters", Rect(48, 0, 16, 16))
    subImage("minotaur", "monsters", Rect(0, 16, 16, 16))
    subImage("sorceror", "monsters", Rect(16, 16, 16, 16))
    subImage("ghost", "monsters", Rect(32, 16, 16, 16))
    subImage("mortipede", "monsters", Rect(48, 16, 16, 16))
    
    subImage("balrog", "monsters", Rect(0, 32, 16, 16))
    subImage("hellrat", "monsters", Rect(16, 32, 16, 16))
    subImage("bones", "monsters", Rect(32, 32, 16, 16))
    subImage("etherbat", "monsters", Rect(48, 32, 16, 16))
    subImage("megataur", "monsters", Rect(0, 48, 16, 16))
    subImage("liche", "monsters", Rect(16, 48, 16, 16))
    subImage("hungryghost", "monsters", Rect(32, 48, 16, 16))
    subImage("rotworm", "monsters", Rect(48, 48, 16, 16))
            
    loadImage("misc.png")
    subImage("reticule", "misc", Rect(0, 0, 16, 16))
    subImage("cursor", "misc", Rect(16, 0, 16, 16))
    subImage("bigcursor", "misc", Rect(0, 16, 16, 16))
    subImage("checkoff", "misc", Rect(0, 32, 16, 16))
    subImage("checkon", "misc", Rect(16, 32, 16, 16))
    
    loadImage("status.png")
    subImage("fear", "status", Rect(0, 0, 16, 16))
    subImage("poison", "status", Rect(16, 0, 16, 16))
    
    loadImage("pane.png")
    loadImage("possesspane.png")
    loadImage("bottompane.png")
    loadImage("textlog.png")
    loadImage("gameover.png")
    loadImage("titlescreen.png")
    loadImage("mainmenu.png")
    loadImage("tilebackground.png")
    loadImage("spotlight.png")

    loadSound("bump.wav")
    loadSound("swing.wav")
    loadSound("nope.wav")
    loadSound("possess.wav")
    loadSound("envenom.wav")
    loadSound("uiping.wav")
    loadSound("fireball.wav")
    loadSound("magic.wav")
    loadSound("charge.wav")
    
    loadMusic("dungeon1.ogg", True, True)
    loadMusic("dungeon2.ogg", True, True)
    loadMusic("dungeon3.ogg", True, True)

def getImage(name):
    return images[name]

def getSound(name):
    return sounds[name]

def getMusic(name):
    return music[name]