import math
import content
import pc
import weakref

tileSize = 16
screenWidth = 320
screenHeight = 240
scale = 2
roomSize = 8
floorWidth = 8
floorHeight = 5

player = pc.Player()
game = None
logText = []

def log(text):
    global logText
    
    if len(logText) > 20:
        logText.pop()
        
    logText.insert(0, text)
    
def clearLog():
    global logText
    
    del logText[:]

def getName(mob):
    if mob == player.mobile:
        return "You"
    else:
        return mob.getName()

def setGameRef(mainGame):
    global game
    game = weakref.ref(mainGame)

def dist(x1, y1, x2, y2):
    return math.sqrt(math.pow(x1 - x2, 2) + math.pow(y1 - y2, 2))

def playSound(sound):
    try:
        sound.play()
    except:
        print "Sound error in sound %s" % sound