import pygame

class InputHandler(object):
    def __init__(self):
        self.handlers = {}
        self.anyKey = False
        self.anyKeyFunc = None
        self.wasAnyKey = False
        self.lastAnyKey = -1
    
    def clearHandlers(self):
        self.handlers.clear()
    
    def attachHandler(self, event, key, func, info):
        self.handlers[(event, key)] = (func, info)
        
    def tryHandle(self, event, key):
        if self.anyKey and event == pygame.KEYDOWN:
            self.anyKeyFunc(key)
            self.anyKey = False
            self.anyKeyFunc = None
            self.wasAnyKey = True
            self.lastAnyKey = key
            return
        
        if (event, key) in self.handlers.keys():
            if self.wasAnyKey and self.lastAnyKey == key and event == pygame.KEYUP:
                self.wasAnyKey = False
                return
            funcInfoTuple = self.handlers[(event, key)]
            funcInfoTuple[0](event, key, funcInfoTuple[1])
            
    def pressAnyKey(self, func):
        self.anyKey = True
        self.anyKeyFunc = func