import random

def clamp(value, minVal = 0.0, maxVal = 1.0):
    return min(max(value, minVal), maxVal)

def success(chance):
    return random.random() <= chance

def lerp(a, b, w, clamped=True):
    if clamped:
        w = min(max(w, 0.0), 1.0)
    v = a + w*(b-a)
    return a + w*(b-a)

class Ray(object):
    def __init__(self, p0, p1):
        self.points = []
        self.done = False
        
        self.x1 = p0[0]
        self.x2 = p1[0]
        self.y1 = p0[1]
        self.y2 = p1[1]

        self.steep = abs(self.y2 - self.y1) > abs(self.x2 - self.x1)
        if self.steep:
            self.x1, self.y1 = self.y1, self.x1
            self.x2, self.y2 = self.y2, self.x2
            
        if self.x1 > self.x2:
            self.reversed = True
            self.xstep = -1
        else:
            self.reversed = False
            self.xstep = 1
        
        if self.y1 < self.y2:
            self.ystep = 1
        else:
            self.ystep = -1
            
        self.dx = abs(self.x2 - self.x1)
        self.dy = abs(self.y2 - self.y1)
        
        self.error = 0
        self.y = self.y1
        self.x = self.x1
        
    def cast(self):
        if not self.done:
            self.points = []
            while not self.done:
                self.points.append(self.step())
        return self.points

    def step(self):
        if self.done:
            return None
        
        if self.steep:
            p = (self.y, self.x)
        else:
            p = (self.x, self.y)
            
        self.points.append(p)
        
        if self.reversed:
            if self.x <= self.x2:
                self.done = True
                return p
        else:
            if self.x >= self.x2:
                self.done = True
                return p
                
        self.error = self.error + self.dy
        if (self.error << 1) >= self.dx:
            self.y = self.y + self.ystep
            self.error = self.error - self.dx
        
        self.x += self.xstep
        
        return p