from enum import *

class MenuOption(object):
    def __init__(self, name, cfgName, cfgSection, value, optType, desc):
        self.name = name
        self.cfgName = cfgName
        self.cfgSection = cfgSection
        self.desc = desc
        self.value = value
        self.altValue = None
        self.type = optType
        
    def setValue(self, value):
        self.value = value
        
class MenuOptionBool(MenuOption):
    def __init__(self, name, cfgName, cfgSection, desc):
        MenuOption.__init__(self, name, cfgName, cfgSection, False, OptionType.BOOL, desc)
        
    def toggle(self):
        self.setValue(not self.value)

class MenuOptionInt(MenuOption):
    def __init__(self, minValue, maxValue, name, cfgName, cfgSection, desc, stepValue=1):
        MenuOption.__init__(self, name, cfgName, cfgSection, 0, OptionType.INT, desc)
        self.minValue = minValue
        self.maxValue = maxValue
        self.stepValue = stepValue
        
    def stepUp(self):
        self.step(self.stepValue)
        
    def stepDown(self):
        self.step(-self.stepValue)
        
    def step(self, value):
        newVal = self.value + value
        if newVal > self.maxValue:
            newVal = self.maxValue
        elif newVal < self.minValue:
            newVal = self.minValue
            
        self.setValue(newVal)
        

class MenuOptionKey(MenuOption):
    def __init__(self, name, cfgName, cfgSection, desc):
        MenuOption.__init__(self, name, cfgName, cfgSection, None, OptionType.KEY, desc)


class Key(MenuOptionKey):
    def __init__(self, name):
        MenuOptionKey.__init__(self, name, name, "KeyBinds", "")

class Header(MenuOption):
    def __init__(self, name):
        MenuOption.__init__(self, name, "_header_%s" % name, "", None, OptionType.HEADER, "")

class Blank(MenuOption):
    def __init__(self, name):
        MenuOption.__init__(self, "", "_blank_%s" % name, "", None, OptionType.BLANK, "")
        
class MasterVolume(MenuOptionInt):
    def __init__(self):
        MenuOptionInt.__init__(self, 0, 100, "Master volume", "mastervolume", "Engine", "Adjust the master sound volume", 5)

class SoundVolume(MenuOptionInt):
    def __init__(self):
        MenuOptionInt.__init__(self, 0, 100, "Sound volume", "soundvolume", "Engine", "Adjust sound effect volume", 5)

class MusicVolume(MenuOptionInt):
    def __init__(self):
        MenuOptionInt.__init__(self, 0, 100, "Music volume", "musicvolume", "Engine", "Adjust music volume", 5)

class AttackOnBump(MenuOptionBool):
    def __init__(self):
        MenuOptionBool.__init__(self, "Attack when bumping into monsters", "attackonbump", "Engine", "Moving into an enemy attacks")

class AttackConfirms(MenuOptionBool):
    def __init__(self):
        MenuOptionBool.__init__(self, "Attack key also confirms attacks", "attackconfirms", "Engine", "The attack button also confirms your target")

class RememberTarget(MenuOptionBool):
    def __init__(self):
        MenuOptionBool.__init__(self, "Remember target", "remembertarget", "Engine", "Cursor remembers your last target")

class MultiKeyDiagonals(MenuOptionBool):
    def __init__(self):
        MenuOptionBool.__init__(self, "Multi-key diagonals", "multikeydiagonals", "Engine", "Move diagonally by pressing a combination of direction keys")

