import random

import skills
import mobs
import engine

class FormData(object):
    def __init__(self, name, hazard, expToLevel, nextSkill, exp=0, skillExp=0, level=1, mastered=False, \
                 health=0, strength=0, agi=0, con=0, mag=0, wil=0, statPoints=0):
        self.name = name
        self.exp = exp
        self.expToLevel = expToLevel
        self.skillExp = skillExp
        self.nextSkill = nextSkill
        self.level = level
        self.hazard = hazard
        self.mastered = mastered
        self.statPoints = statPoints
        
        self.health = health
        self.str = strength
        self.agi = agi
        self.con = con
        self.mag = mag
        self.wil = wil

class Player(object):
    def __init__(self):
        self.reset()
        
    def reset(self):
        self.tracking = -1
        self.health = 0
        self.str = 0
        self.agi = 0
        self.con = 0
        self.mag = 0
        self.wil = 0
        
        self.masterHealth = 0
        self.masterStr = 0
        self.masterAgi = 0
        self.masterCon = 0
        self.masterMag = 0
        self.masterWil = 0
        
        self.maxSp = 1
        self.sp = self.maxSp
        
        self.exp = 0
        self.expToLevel = 1
        self.level = 1
        self.statPoints = 0
        self.floor = 1
        self.exploredFloors = 1
        
        self.formData = {}
        
        self.skills = []
        self.mobile = mobs.Mobile(0, 0, 0)
        
        self.addSkill(skills.Possess())
        self.addSkill(skills.Depossess())
        
        self.saveData = { "version": 0 }
        
    def save(self):
        # auto save integral types
        for attr, value in self.__dict__.items():
            if value == None or isinstance(value, (bool, basestring, float, int, long)):
                self.saveData[attr] = value
                
        saveSkills = []
        for skill in self.skills:
            saveSkills.append(skill.getClassName())
        self.saveData["saveSkills"] = saveSkills
        
        self.saveData["formData"] = {}
        for form in self.formData.values():
            self.saveData["formData"][form.name] = {}
            for attr, value in form.__dict__.items():
                self.saveData["formData"][form.name][attr] = value
        
    def load(self, data):
        self.saveData = data
        
        # auto load integral types
        for attr, value in self.saveData.items():
            if value == None or isinstance(value, (bool, basestring, float, int, long)):
                self.__dict__[attr] = value
                
        for skill in self.saveData["saveSkills"]:
            cls = skills.__dict__[skill]
            self.addSkill(cls())
            
        for form in self.saveData["formData"].values():
            self.formData[form["name"]] = FormData(form["name"], form["hazard"], \
                form["expToLevel"], form["nextSkill"], form["exp"], form["skillExp"], form["level"], form["mastered"], \
                form["health"], form["str"], form["agi"], form["con"], form["mag"], form["wil"], \
                form["statPoints"])
        
    def possess(self, mob):
        self.mobile = mob
        self.tracking = mob.ID
        
        for skill in self.skills:
            self.mobile.addSkill(skill, False)
            
        data = self.getFormData()
        
        if data != None:
            self.formHealth = data.health
            self.formStr = data.str
            self.formAgi = data.agi
            self.formCon = data.con
            self.formMag = data.mag
            self.formWil = data.wil
             
    def addSkill(self, skill):
        for sk in self.skills:
            if sk.name == skill.name:
                return
        self.skills.append(skill)
        self.mobile.addSkill(skill, False)
        
    def gainExpFromMobile(self, mobile):
        exp = self.getHazardRating(mobile.getName())
        self.gainExp(int(round(pow(exp, 1.5))))
        self.addFormExp(exp)
        return exp
    
    def getSkillExp(self, name):
        if name in self.formData:
            return self.formData[name].skillExp
        else:
            return 0
    
    def getSkillExpToLevel(self):
        name = self.mobile.getName()

        if name in self.formData:
            return self.formData[name].nextSkill
        else:
            return self.getHazardRating(name) * 5
            
    def getFormExp(self, name):
        if name in self.formData:
            return self.formData[name].exp
        else:
            return 0
    
    def getFormExpToLevel(self):
        name = self.mobile.getName()

        if name in self.formData:
            return self.formData[name].expToLevel
        else:
            return self.getHazardRating(name) * 5
        
    def getHazardRating(self, name):
        hazard = 0
        if name == "Imp":
            hazard = 1
        else:
            hazard = mobs.hazardRatings[name]
        return hazard
            
    def getFormData(self, name=None):
        if name == None:
            name = self.mobile.getName()
        
        requiredExp = self.getFormExpToLevel()
        if not name in self.formData:
            self.formData[name] = FormData(name, self.getHazardRating(name), requiredExp, requiredExp)
            
        if name == "Imp":
            self.formData[name].mastered = True
            
        return self.formData[name]
    
    def isFormMaster(self):
        data = self.getFormData()
        if data == None:
            return False
        return data.mastered
    
    def getFormPoints(self):
        data = self.getFormData()
        if data == None:
            return 0
        return data.statPoints
               
    def addFormExp(self, exp):
        data = self.getFormData()
        if data == None: # is imp
            return
        
        requiredExp = data.expToLevel
        if requiredExp == None:
            return
        
        if data.mastered:
            data.exp += exp
        data.skillExp += exp
        
        while data.skillExp >= data.nextSkill:
            self.learnNewAbility()
            data.skillExp -= data.nextSkill
        
        levelsGained = 0
        while data.exp >= data.expToLevel:
            data.exp -= data.expToLevel
            data.level += 1
            levelsGained += 1
            data.expToLevel += int(round(pow(data.level, 1.5)))
            data.statPoints += 3
            
        if levelsGained > 0:
            if levelsGained > 1:
                engine.log("Your form has leveled up! Gained %s levels!" % levelsGained)
            else:
                engine.log("Your form has leveled up!")
                    
    def getUnlearnedSkills(self):
        skills = self.mobile.baseSkills
        unlearnedSkills = []
        
        for skill in skills:
            found = False
            for knownSkill in self.skills:
                if knownSkill.name == skill.name:
                    found = True
                    break
            
            if not found:
                unlearnedSkills.append(skill)
                
        return unlearnedSkills
            
    def learnNewAbility(self):
        unlearnedSkills = self.getUnlearnedSkills()
        if len(unlearnedSkills) == 0:
            return
        
        newSkill = unlearnedSkills[random.randint(0, len(unlearnedSkills) - 1)]
        self.skills.append(newSkill)
        
        engine.log("You have learned the ability %s!" % newSkill.name)
        
    def checkMastery(self):
        data = self.getFormData()
        if data == None: # is imp
            return
        
        if data.mastered:
            return
        
        if self.health >= self.mobile.formHealth and \
        self.str >= self.mobile.formStr and \
        self.agi >= self.mobile.formAgi and \
        self.con >= self.mobile.formCon and \
        self.mag >= self.mobile.formMag and \
        self.wil >= self.mobile.formWil:
            data.mastered = True
            self.masterHealth += self.mobile.masterBonus[0]
            self.masterStr += self.mobile.masterBonus[1]
            self.masterAgi += self.mobile.masterBonus[2]
            self.masterCon += self.mobile.masterBonus[3]
            self.masterMag += self.mobile.masterBonus[4]
            self.masterWil += self.mobile.masterBonus[5]
            
            self.mobile.health += self.mobile.masterBonus[0]
            self.mobile.maxHealth += self.mobile.masterBonus[0]
            self.mobile.str += self.mobile.masterBonus[1]
            self.mobile.agi += self.mobile.masterBonus[2]
            self.mobile.con += self.mobile.masterBonus[3]
            self.mobile.mag += self.mobile.masterBonus[4]
            self.mobile.wil += self.mobile.masterBonus[5]
                
    def regenSp(self):
        self.sp += self.level * 0.025
        if self.sp > self.maxSp:
            self.sp = self.maxSp
         
    def gainExp(self, exp):
        self.exp += exp

        levelsGained = 0
        while self.exp >= self.expToLevel:
            # currently makes the start too hard
            #if self.isFormMaster():
            #    self.exp = self.expToLevel
            #    return 0
        
            levelsGained += 1
            self.level += 1
            self.maxSp += 1
            self.sp += 1
            self.statPoints += 3
            self.expToLevel += int(round(pow(self.level, 2.1)))
                
            if levelsGained > 0:
                if levelsGained > 1:
                    engine.log("Level up! You have gained %s levels!" % levelsGained)
                else:
                    engine.log("Level up!")
    
            return levelsGained