import sqlite3 as sql
import os

try:
    import cPickle as pickle
except:
    import pickle
try:
    from cStringIO import StringIO
except:
    from StringIO import StringIO

class Save(object):
    def __init__(self, file):
        self.file = file
        self.con = None
        self.closed = True
        self.open()

    def open(self):
        self.con = sql.connect(self.file)
        self.closed = False
        
    def close(self):
        self.con.close()
        self.closed = True
        
    def createTables(self):
        self.con.execute("CREATE TABLE Floors(Floor INTEGER PRIMARY KEY, Data TEXT)")
        self.con.execute("CREATE TABLE Player(ID INTEGER PRIMARY KEY, Data TEXT)")
        self.con.execute("INSERT INTO Player VALUES(?, ?)", (0, ""))

    def addFloor(self, floor):
        data = self.pickle(floor.saveData)
        self.con.execute("INSERT INTO Floors VALUES(?, ?)", (floor.number, data))
        
    def saveFloor(self, floor):
        data = self.pickle(floor.saveData)
        self.con.execute("UPDATE Floors SET Data=? WHERE Floor=?", (data, floor.number))
        
    def savePlayer(self, player):
        data = self.pickle(player.saveData)
        self.con.execute("UPDATE Player SET Data=? WHERE ID=?", (data, 0))
        
    def commit(self):
        self.con.commit()
        
    def getFloorData(self, floor):
        for row in self.con.execute("SELECT Data FROM Floors WHERE Floor=?", (floor,)):
            text = row[0]
            break
        return self.unpickle(text)
    
    def getPlayerData(self):
        for row in self.con.execute("SELECT Data FROM Player WHERE ID=0"):
            text = row[0]
            break
        return self.unpickle(text)
        
    def pickle(self, obj):
        file = StringIO()
        pickle.dump(obj, file)
        return file.getvalue()
    
    def unpickle(self, string):
        file = StringIO(string)
        return pickle.load(file)

def createNew(fileName):
    if os.path.exists(fileName):
        os.remove(fileName)

    save = Save(fileName)
    save.open()
    save.createTables()
    
    return save