import threading

import pygame

masterVolume = 1.0
soundVolume = 0.0

class Sound(object):
    def __init__(self, fileName, threaded=False, regulateVolume=True):
        self.snd = None
        self.thread = None
        self.regulateVolume = regulateVolume
        
        if not threaded:
            self.snd = pygame.mixer.Sound(fileName)
        else:
            self.thread = ThreadedSoundLoad(fileName)
            self.thread.start()
        
    def play(self):
        if self.snd == None:
            if not self.checkThread():
                return
        if self.regulateVolume:
            self.snd.set_volume(masterVolume * soundVolume)
        self.snd.play()
        
    def get_length(self):
        if self.snd == None:
            if not self.checkThread():
                return 0
        return self.snd.get_length()
    
    def checkThread(self):
        if self.snd != None:
            return True
        if self.thread.done:
            self.snd = self.thread.sound
            self.thread = None
            return True
        return False
    
class ThreadedSoundLoad(threading.Thread):
    def __init__(self, fileName):
        threading.Thread.__init__(self)
        self.done = False
        self.sound = None
        self.fileName = fileName
    
    def run(self):
        self.sound = pygame.mixer.Sound(self.fileName)
        self.done = True
