import random

from enum import *

import mobs
import maps

def spawn(level, room):
    hazard = room.hazard
    maxHazard = max(hazard, 1)
    
    if hazard < 1:
        return
    
    spawnable = []
    
    for (k, v) in mobs.sortedHazardRatings:
        if v > maxHazard:
            break
        if k != "Balrog" or level >= 20:
            spawnable.append(k)
        
    if len(spawnable) == 0:
        return
    
    while hazard > 0:
        randomMob = spawnable[random.randint(0, len(spawnable) - 1)]
        hazard -= mobs.hazardRatings[randomMob]
        
        tile = maps.TileOutOfBounds()
        mobX = -1
        mobY = -1
        roomX = room.size * room.x
        roomY = room.size * room.y
        while tile.type != maps.TileType.FLOOR or level.checkCanMove(mobX, mobY) != None:
            mobX = roomX + random.randint(room.floor.left, room.floor.right - 1)
            mobY = roomY + random.randint(room.floor.top, room.floor.bottom - 1)
            
            tile = level.getTile(mobX, mobY)
        
        level.addMobile(mobs.spawnByName(randomMob, mobX, mobY))